<?php
declare(strict_types=1);

namespace App\Services;

use App\Models\User;

final class Auth
{
    public static function user(): ?array
    {
        $id = $_SESSION['uid'] ?? null;
        if (!$id) return null;
        return User::findById((int)$id);
    }

    public static function check(): bool
    {
        return !empty($_SESSION['uid']);
    }

    public static function login(int $userId): void
    {
        session_regenerate_id(true);
        $_SESSION['uid'] = $userId;
    }

    public static function logout(): void
    {
        $_SESSION = [];
        if (ini_get('session.use_cookies')) {
            $params = session_get_cookie_params();
            setcookie(session_name(), '', time()-42000, $params['path'], $params['domain'], (bool)$params['secure'], (bool)$params['httponly']);
        }
        session_destroy();
    }

    public static function requireUser(): array
    {
        $u = self::user();
        if (!$u) { Util::redirect('/login'); }
        return $u;
    }

    public static function requireAdmin(): array
    {
        $u = self::requireUser();
        if (($u['role'] ?? 'user') !== 'admin') {
            http_response_code(403);
            echo 'Forbidden';
            exit;
        }
        return $u;
    }
}
