<?php
declare(strict_types=1);

namespace App\Services;

final class CSRF
{
    public static function token(): string
    {
        if (empty($_SESSION['csrf'])) {
            $_SESSION['csrf'] = bin2hex(random_bytes(32));
        }
        return $_SESSION['csrf'];
    }

    public static function validateOrFail(): void
    {
        $token = $_POST['csrf'] ?? '';
        if (!is_string($token) || empty($_SESSION['csrf']) || !hash_equals($_SESSION['csrf'], $token)) {
            http_response_code(403);
            echo 'CSRF validation failed';
            exit;
        }
    }
}
