<?php
declare(strict_types=1);

namespace App\Services;

final class Config
{
    private static array $cfg = [];

    public static function isInstalled(): bool
    {
        return is_file(__DIR__ . '/../../config/config.php');
    }

    public static function loadIfPresent(): void
    {
        $path = __DIR__ . '/../../config/config.php';
        if (is_file($path)) {
            self::$cfg = require $path;
        }
    }

    public static function get(string $key, $default = null)
    {
        return self::$cfg[$key] ?? $default;
    }

    public static function all(): array
    {
        return self::$cfg;
    }
}
