<?php
declare(strict_types=1);

namespace App\Services;

final class Mailer
{
    public static function send(string $to, string $subject, string $html): bool
    {
        $from = (string)Config::get('mail_from','no-reply@' . ($_SERVER['HTTP_HOST'] ?? 'localhost'));
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8\r\n";
        $headers .= "From: {$from}\r\n";
        // NOTE: On some hosts, mail() may be disabled. You can swap this for SMTP later.
        return @mail($to, $subject, $html, $headers);
    }
}
