<?php
declare(strict_types=1);

namespace App\Services;

final class Router
{
    private array $routes = ['GET'=>[], 'POST'=>[]];

    public function get(string $path, string $handler): void { $this->routes['GET'][$path] = $handler; }
    public function post(string $path, string $handler): void { $this->routes['POST'][$path] = $handler; }

    public function dispatch(string $method, string $uri): void
    {
        $path = parse_url($uri, PHP_URL_PATH) ?? '/';
        $handler = $this->routes[$method][$path] ?? null;
        if (!$handler) {
            http_response_code(404);
            echo "<h1>404</h1>";
            return;
        }
        [$class, $fn] = explode('@', $handler, 2);
        if (!class_exists($class)) { http_response_code(500); echo "Handler missing"; return; }
        $obj = new $class();
        if (!method_exists($obj, $fn)) { http_response_code(500); echo "Handler method missing"; return; }
        $obj->$fn();
    }
}
