<?php
declare(strict_types=1);

namespace App\Services;

final class SecurityHeaders
{
    public static function apply(): void
    {
        // Basic security headers (tweak CSP if you add external assets)
        header('X-Frame-Options: DENY');
        header('X-Content-Type-Options: nosniff');
        header('Referrer-Policy: strict-origin-when-cross-origin');
        header('Permissions-Policy: geolocation=(), microphone=(), camera=()');

        $csp = "default-src 'self'; base-uri 'self'; form-action 'self'; frame-ancestors 'none'; ";
        $csp .= "img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self' https://challenges.cloudflare.com; ";
        $csp .= "connect-src 'self';";
        header('Content-Security-Policy: ' . $csp);
    }
}
