<?php
declare(strict_types=1);

namespace App\Services;

final class Turnstile
{
    public static function verify(string $token, string $remoteIp): bool
    {
        $secret = (string)Config::get('turnstile_secret','');
        if ($secret === '') return true; // allow if not configured

        $payload = http_build_query([
            'secret' => $secret,
            'response' => $token,
            'remoteip' => $remoteIp,
        ]);

        $ch = curl_init('https://challenges.cloudflare.com/turnstile/v0/siteverify');
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 8,
        ]);
        $resp = curl_exec($ch);
        curl_close($ch);
        if (!is_string($resp)) return false;
        $json = json_decode($resp, true);
        return is_array($json) && !empty($json['success']);
    }
}
