<?php
declare(strict_types=1);

namespace App\Services;

final class Util
{
    public static function hmac(string $value): string
    {
        $key = (string)Config::get('app_key','');
        return hash_hmac('sha256', $value, $key);
    }

    public static function clientIp(): string
    {
        // Trust only REMOTE_ADDR by default (do NOT trust X-Forwarded-For unless configured)
        return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    }

    public static function userAgent(): string
    {
        return $_SERVER['HTTP_USER_AGENT'] ?? '';
    }

    public static function redirect(string $path): void
    {
        header('Location: ' . $path);
        exit;
    }

    public static function esc(string $s): string
    {
        return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
    }
}
