<?php
declare(strict_types=1);

namespace App\Services;

final class View
{
    public static function render(string $template, array $data=[]): void
    {
        extract($data, EXTR_SKIP);
        $path = __DIR__ . '/../Views/' . $template . '.php';
        if (!is_file($path)) {
            http_response_code(500);
            echo 'View missing';
            return;
        }
        require $path;
    }
}
